﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace DumpAndBurn
{
    public class LFDumpNozzle : PartModule
    {
        [KSPField(guiActive = true, guiActiveEditor = true, guiFormat = "F1", guiName = "Nozzle Size", isPersistant = true), UI_FloatRange(scene = UI_Scene.Editor, minValue = 0.1f, maxValue = 10f)]
        float nozzleSize;

        [KSPAction(guiName = "Toggle Nozzle")]
        void ActionToggle(KSPActionParam ap)
        {
            part.enabled = !part.enabled;
        }
        [KSPAction(guiName = "Open Nozzle")]
        void ActionOpen(KSPActionParam ap)
        {
            part.enabled = true;
        }
        [KSPAction(guiName = "Close Nozzle")]
        void ActionClose(KSPActionParam ap)
        {
            part.enabled = false;
        }
        [KSPAction(guiName = "Heat Nozzle")]
        void ActionHeat(KSPActionParam ap)
        {
            part.temperature = 430;
        }

        [KSPEvent(guiActive = true, guiActiveEditor = false, guiName = "Toggle Nozzle")]
        void EventToggle()
        {
            part.enabled = !part.enabled;
        }

        public override void OnUpdate()
        {
            ConsumeFuel(nozzleSize);

            base.OnUpdate();
        }

        public void Update()
        {
            try
            {
                if (part.enabled)
                {
                    StartFx();
                }
                else
                {
                    StopFx();
                }
            }catch(Exception e)
            {

            }
        }

        public override void OnLoad(ConfigNode node)
        {
            print("Nozzle onLoad");
            InitializeFx();
            nozzleSize = float.Parse(node.GetValue("nozzleSize"));
            part.enabled = false;

            base.OnLoad(node);
        }

        public void ConsumeFuel(float nozzle)
        {
            int tankNumber = 0;
            double fuelAmount = 0;
            foreach (Part p in vessel.Parts)
            {
                foreach (PartResource r in p.Resources)
                {
                    if (r.resourceName == "LiquidFuel")
                    {
                        tankNumber++;
                        fuelAmount += r.amount;
                    }
                }
            }
            if (fuelAmount > 0)
            {
                foreach (Part p in vessel.Parts)
                {
                    foreach (PartResource r in p.Resources)
                    {
                        if (r.resourceName == "LiquidFuel")
                        {
                            r.amount -= nozzle / tankNumber * UnityEngine.Time.deltaTime * 50;
                            if (r.amount < 0) r.amount = 0;
                        }
                    }
                }
            }
        }//ConsumeFuel

        KSPParticleEmitter dumpFx;
        KSPParticleEmitter burnFx;
        public void InitializeFx()
        {
            foreach (KSPParticleEmitter pa in part.FindModelComponents<KSPParticleEmitter>())
            {
                if (pa.name == "dump") dumpFx = pa;
                if (pa.name == "burn") burnFx = pa;
            }
            dumpFx.emit = false;
            burnFx.emit = false;
        }

        public void StartFx()
        {
            EffectBehaviour.AddParticleEmitter(dumpFx);
            EffectBehaviour.AddParticleEmitter(burnFx);
            if (part.temperature < 400)
            {
                dumpFx.emit = true;
                burnFx.emit = false;
            }
            else
            {
                dumpFx.emit = false;
                burnFx.emit = true;
            }
        }

        public void StopFx()
        {
            dumpFx.emit = false;
            burnFx.emit = false;
            EffectBehaviour.RemoveParticleEmitter(dumpFx);
            EffectBehaviour.RemoveParticleEmitter(burnFx);
        }


    }
}
